Imports comments.DynaPDF

Module Module1

   ' Error callback function.
   ' If the function name should not appear at the beginning of the error message then set
   ' the flag emNoFuncNames (pdf.SetErrorMode(CPDF.TErrMode.emNoFuncNames)).
   Private Function PDFError(ByVal Data As IntPtr, ByVal ErrCode As Integer, ByVal ErrMessage As IntPtr, ByVal ErrType As Integer) As Integer
      Console.WriteLine("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage))
      Return 0 ' We try to continue if an error occurrs. Any other return value breaks processing.
   End Function


   ' Incremental updates are useful if small changes should be saved quickly, e.g. when adding an annotation or reply to one,
   ' adding form fields and so on.

   ' This example is a bit simplified since we know that the file contains only one annotation and a handle of an annotation
   ' is just an array index from 0 though annotation count -1.

   Function CreateTestFile(PDF As CPDF) As Byte()
      PDF.CreateNewPDF(Nothing)

      PDF.SetPageCoords(TPageCoord.pcTopDown)

      PDF.Append()
         PDF.SquareAnnot(50.0, 50.0, 200.0, 100.0, 3.0, CPDF.NO_COLOR, 255, TPDFColorSpace.csDeviceRGB, "Jim", "Test", "Just test...")
      PDF.EndPage()

      if not PDF.CloseFile() then return Nothing
      ' This function creates a copy of the buffer and this is exactly what we need in this example.
      dim buffer As Byte() = PDF.GetBuffer()

      ' We can release the original buffer. This also resets the PDF instance,
      ' just as CloseFile() would do if the file would be created on a local drive.
      PDF.FreePDF()
      return buffer
   End Function

   Function LoadTestFile(PDF As CPDF, Buffer As Byte())As Boolean
      PDF.CreateNewPDF(Nothing)
      ' This flag also sets the flags ifImportAsPage | ifImportAll, and if2UseProxy | if2CopyEncryptDict to make sure that
      ' anything is imported and nothing gets changed.
      PDF.SetImportFlags2(TImportFlags2.if2IncrementalUpd)
      if PDF.OpenImportBuffer(Buffer, TPwdType.ptOpen, Nothing) < 0 then return false
      return PDF.ImportPDFFile(1, 1.0, 1.0) > 0
   End Function

   Function SaveFile(PDF As CPDF)As Byte()
      if not PDF.CloseFile() then return Nothing
      dim retval As Byte() = PDF.GetBuffer()
      ' We can release the original buffer. This also resets the PDF instance,
      ' just as CloseFile() would do if the file would be created on a local drive.
      PDF.FreePDF()
      return retval
   End Function

   Sub Main()
      Try
         dim reply As Integer
         dim buffer As Byte()
         dim pdf As CPDF = new CPDF()
         pdf.SetOnErrorProc(AddressOf PDFError)

         ' We create the base file in memory in this example
         buffer = CreateTestFile(pdf)

         ' CreateTest() created a copy of the PDF buffer. We are now the owner of the buffer.
         ' The PDF instance has now it's inital state with the exception that the font cache, if already loaded, stays in memory.
         if LoadTestFile(pdf, buffer) then
            ' We don't need the buffer anymore
            buffer = Nothing
            ' We do not search for the annotation here since we know that the file contains only one annotation
            ' and the handle of this annotation is zero since this is just an array index.
            reply = pdf.SetAnnotMigrationState(0, TAnnotState.asCreateReply, "Harry")
            pdf.SetAnnotString(reply, TAnnotString.asContent, "Hi Jim, your test annotation looks fine!")
            buffer = SaveFile(pdf)
            if LoadTestFile(pdf, buffer) then
               buffer = Nothing

               reply = pdf.SetAnnotMigrationState(reply, TAnnotState.asCreateReply, "Tommy")
               pdf.SetAnnotString(reply, TAnnotString.asContent, "Just a test whether I can reply to a reply...")
               buffer = SaveFile(pdf)
               if LoadTestFile(pdf, buffer) then
                  buffer = Nothing

                  reply = pdf.SetAnnotMigrationState(reply, TAnnotState.asCreateReply, "Jim")
                  pdf.SetAnnotString(reply, TAnnotString.asContent, "Seems to work very well!")
                  ' No fatal error occurred?
                  if pdf.HaveOpenDoc() then
                     ' We write the output file into the current directory.
                     dim filePath as String = System.IO.Directory.GetCurrentDirectory() + "\out.pdf"
                     ' OK, now we can open the output file.
                     if not pdf.OpenOutputFile(filePath) then return
                     if pdf.CloseFile() then
                        Console.Write("PDF file ""{0}"" successfully created!" + Chr(10), filePath)
                        Dim p As System.Diagnostics.Process = New System.Diagnostics.Process()
                        p.StartInfo.FileName = filePath
                        p.Start()
                     End if
                  End if
               End if
            End if
         End if
      Catch e As Exception
         Console.Write(e.Message + Chr(10))
         Console.Read()
      End Try
   End Sub

End Module
